//====================================================================================
//  Copyright (C) BAY9, 2014
//====================================================================================
//
// MODULE:
//   crdcAbs
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module crdcAbs(yAbs, yAbs_or, yAbs_ff, yAbs_we, 
               yPh, yPh_or, yPh_ff, yPh_we, 
               xRe, xRe_ir, xRe_fe, xRe_re, 
               xIm, xIm_ir, xIm_fe, xIm_re, 
               run1, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yAbs_w            = 0;
  parameter yPh_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;

  parameter run1_w            = 0;

  parameter w                 = 0;
  parameter wa                = 0;
  parameter wp                = 0;
  parameter wi                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output         [yAbs_w-1:0]  yAbs;
  output                       yAbs_or;
  input                        yAbs_ff;
  output                       yAbs_we;
  assign                       yAbs_we = yAbs_or & ~yAbs_ff;

  output          [yPh_w-1:0]  yPh;
  output                       yPh_or;
  input                        yPh_ff;
  output                       yPh_we;
  assign                       yPh_we = yPh_or & ~yPh_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "crdcAbsCore_00x20x20.v"
  `include "crdcAbsCore_01x20x20.v"
  `include "crdcAbsCore_02x20x20.v"
  `include "crdcAbsCore_03x20x20.v"
  `include "crdcAbsCore_04x20x20.v"
  `include "crdcAbsCore_05x20x20.v"
  `include "crdcAbsCore_06x20x20.v"
  `include "crdcAbsCore_07x20x20.v"
  `include "crdcAbsCore_08x20x20.v"
  `include "crdcAbsCore_09x20x20.v"
  `include "crdcAbsCore_10x20x20.v"
  `include "crdcAbsCore_11x20x20.v"
  `include "crdcAbsCore_12x20x20.v"
  `include "crdcAbsCore_13x20x20.v"
  `include "crdcAbsCore_14x20x20.v"
  `include "crdcAbsCore_15x20x20.v"
  `include "crdcAbsCore_16x20x20.v"

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | crdcAbsCore_00x20x20_regWe | crdcAbsCore_01x20x20_regWe | crdcAbsCore_02x20x20_regWe
                      | crdcAbsCore_03x20x20_regWe | crdcAbsCore_04x20x20_regWe | crdcAbsCore_05x20x20_regWe
                      | crdcAbsCore_06x20x20_regWe | crdcAbsCore_07x20x20_regWe | crdcAbsCore_08x20x20_regWe
                      | crdcAbsCore_09x20x20_regWe | crdcAbsCore_10x20x20_regWe | crdcAbsCore_11x20x20_regWe
                      | crdcAbsCore_12x20x20_regWe | crdcAbsCore_13x20x20_regWe | crdcAbsCore_14x20x20_regWe
                      | crdcAbsCore_15x20x20_regWe | crdcAbsCore_16x20x20_regWe;
  assign regReOut = 0 | crdcAbsCore_00x20x20_regRe | crdcAbsCore_01x20x20_regRe | crdcAbsCore_02x20x20_regRe
                      | crdcAbsCore_03x20x20_regRe | crdcAbsCore_04x20x20_regRe | crdcAbsCore_05x20x20_regRe
                      | crdcAbsCore_06x20x20_regRe | crdcAbsCore_07x20x20_regRe | crdcAbsCore_08x20x20_regRe
                      | crdcAbsCore_09x20x20_regRe | crdcAbsCore_10x20x20_regRe | crdcAbsCore_11x20x20_regRe
                      | crdcAbsCore_12x20x20_regRe | crdcAbsCore_13x20x20_regRe | crdcAbsCore_14x20x20_regRe
                      | crdcAbsCore_15x20x20_regRe | crdcAbsCore_16x20x20_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================
  
  // --------------------------------------------------------------------------------------
  // Dummy module - no processing
  // --------------------------------------------------------------------------------------
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xRe_ir   = run1;
  assign xIm_ir   = run1;
  assign yAbs     = 0;
  assign yPh      = 0;
  assign yAbs_or  = 0;
  assign yPh_or   = 0;

endmodule
//=========================================================================================

