//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   awgn
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module awgn(yRe, yRe_or, yRe_ff, yRe_we, 
            yIm, yIm_or, yIm_ff, yIm_we, 
            xRe, xRe_ir, xRe_fe, xRe_re, 
            xIm, xIm_ir, xIm_fe, xIm_re, 
            regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRe_w             = 0;
  parameter yIm_w             = 0;
  parameter xRe_w             = 0;
  parameter xIm_w             = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;

  parameter w                 = 0;
  parameter wn                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output          [yRe_w-1:0]  yRe;
  output                       yRe_or;
  input                        yRe_ff;
  output                       yRe_we;
  assign                       yRe_we = yRe_or & ~yRe_ff;

  output          [yIm_w-1:0]  yIm;
  output                       yIm_or;
  input                        yIm_ff;
  output                       yIm_we;
  assign                       yIm_we = yIm_or & ~yIm_ff;

  input           [xRe_w-1:0]  xRe;
  output                       xRe_ir;
  input                        xRe_fe;
  output                       xRe_re;
  assign                       xRe_re = xRe_ir & ~xRe_fe;

  input           [xIm_w-1:0]  xIm;
  output                       xIm_ir;
  input                        xIm_fe;
  output                       xIm_re;
  assign                       xIm_re = xIm_ir & ~xIm_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "wgn_re.v"
  `include "wgn_im.v"

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | wgn_re_regWe | wgn_im_regWe;
  assign regReOut = 0 | wgn_re_regRe | wgn_im_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg     [w-1:0]  yReR, yImR;
  reg              yRe_orR, yIm_orR;
  wire      [w:0]  addOutRe, addOutIm;
  wire    [w-1:0]  satOutRe, satOutIm;

  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xRe_ir = run1_q;
  assign xIm_ir = run1_q;

  assign yRe_or = yRe_orR;
  assign yIm_or = yIm_orR;
  
  assign yRe = yReR;
  assign yIm = yImR;
  
  // Enable WGN
  assign wgn_re_run1  = run1_q;
  assign wgn_im_run1  = run1_q;
  assign wgn_re_y_ff  = ~xRe_re;
  assign wgn_im_y_ff  = ~xIm_re;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  assign addOutRe = {xRe[w-1], xRe} + {{w-wn+1{wgn_re_y[wn-1]}}, wgn_re_y};
  assign addOutIm = {xIm[w-1], xIm} + {{w-wn+1{wgn_im_y[wn-1]}}, wgn_im_y};

  sat satRe(satOutRe, addOutRe);
  defparam satRe.x_w = w+1;
  defparam satRe.y_w = w;
  
  sat satIm(satOutIm, addOutIm);
  defparam satIm.x_w = w+1;
  defparam satIm.y_w = w;

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1_q==0) begin
      yReR    <= 0;
      yImR    <= 0;
      yRe_orR <= 0; 
      yIm_orR <= 0;
      
    // Normal operation
    end else begin
      
      yRe_orR <= xRe_re;
      yIm_orR <= xIm_re;
      
      // Register update
      if (xRe_re & xIm_re) begin
        yReR  <= satOutRe;
        yImR  <= satOutIm;
      end

    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

