//====================================================================================
//  Copyright (C) BAY9, 2011
//====================================================================================
//
// MODULE:
//   x16Mul
//
// PURPOSE:
//   Signed multiplication
//
// INPUT:
//   x:        1. Operand
//   y:        2. Operand
//   sh:       Shift after mul
//
// OUTPUT:
//   c         Multiplier output
//
//
// DESCRIPTION:
//   Calculate
//
//     c = x*y >> sh
//
//   and select the lower 16 bit of the result. There is no pipelining
//   within this module.
//
// HISTORY:
//   11-Nov-06, Dirk Sommer
//     Initial version
//
//====================================================================================

//========================================================================================
module x16Mul(c, x, y, sh, clk);

  output    [15:0] c;
  input     [15:0] x,y;
  input     [ 3:0] sh;
  input            clk;

  // ---------------------------------------------------------------------------
  // Define output as register
  reg       [15:0] c;
  wire      [30:0] c0;              //intermediate mulitplication result
  reg       [30:0] c1;              //-> registered
  
  // ---------------------------------------------------------------------------
  // Include signed multiplication
  mulSi mulSi0(c0, x, y);
  defparam mulSi0.a_w = 16;
  defparam mulSi0.b_w = 16;
  defparam mulSi0.c_w = 31;

//register mul output
//  always @(posedge clk)
//    c1 <= c0;

//apply shift
  always @(*)
    case (sh[3:0])
//       3: c = c0[30:15];
//       2: c = c0[25:10];
//       1: c = c0[20: 5];
//       0: c = c0[15: 0];
      15: c = c0[30:15];
      14: c = c0[29:14];
      13: c = c0[28:13];
      12: c = c0[27:12];
      11: c = c0[26:11];
      10: c = c0[25:10];
       9: c = c0[24: 9];
       8: c = c0[23: 8];
       7: c = c0[22: 7];
       6: c = c0[21: 6];
       5: c = c0[20: 5];
       4: c = c0[19: 4];
       3: c = c0[18: 3];
       2: c = c0[17: 2];
       1: c = c0[16: 1];
       0: c = c0[15: 0];
    endcase

endmodule

//==============================================================================

    
