function cfm = msgVrfOnOffReq(id, onOff)
% ==============================================================================
%  Copyright (C) BAY9, 2013
% ==============================================================================
%
% Syntax:
%   cfm = msgVrfOnOffReq(id, onOff)
%
% Inputs:
%   id          - Target identifier
%   onOff       - 0=off, 1=on
%
% Outputs:
%   cfm   - MsgIdVrf.OnOffCfm
%
% Description:
%   Switch off and reset (onOff = 0) or on (onOff = 1) all VRF modules. 
%   Configuration settings are not affected when switching off.
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Send message (convert
  req   = [MsgIdVrf.OnOffReq onOff];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);

  % Check confirm
  if (cfm(1) ~= MsgIdVrf.OnOffCfm)
    error('Wrong confirm message received');
  end
  
% ==============================================================================
