function cfm = msgVrfLedBlinkReq(id, blinkPeriod)
%===============================================================================
%  Copyright (C) BAY9, 2014
%===============================================================================
%
% Syntax:
%   cfm = msgVrfLedBlinkReq(id)
%
% Inputs:
%   id          - Target identifier
%   blinkPeriod - LED blinking period in 2^20 cycles, 1..1000, default 5
%
% Outputs:
%   cfm       - MsgId.LedBlinkCfm
%
% Description:
%   Let the LEDs blink for a moment
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;
  
  % Define message core
  id.core = 'vrf';
  
  % Default blink period = 5*2^20 cycles
  if (nargin == 1)
    blinkPeriod = 5;
  end
    
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdVrf.LedBlinkReq, blinkPeriod];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdVrf.LedBlinkCfm)
    fprintf('Error sending TB LED blink request\n');
    pause
  end

%===============================================================================
