function [cfm dat] = msgVrfGetGpiReq(id, mask)
%===============================================================================
%  Copyright (C) BAY9, 2013
%===============================================================================
%
% Syntax:
%   cfm = msgVrfGetGpiReq(id, mask)
%
% Inputs:
%   id          - Target identifier
%   mask        - Mask bits
%
% Outputs:
%   cfm         - MsgIdVrf.GetGpiCfm + input data (masked)
%   dat         - Input data only (masked)
%
% Description:
%   Send the get GPI request message
%
%     req = [MsgIdVrf.GetGpiReq, mask]
%
%   and read the input data value. The output corresponds to the input
%   data bits when the corresponding masks bits are set, all other bits
%   are zero.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdVrf.GetGpiReq, mask];
  nCfm  = 2;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdVrf.GetGpiCfm)
    fprintf('Error sending get GPI request\n');
    pause
  end

  % Get data only
  dat = cfm(2);

%===============================================================================
