function cfm = msgVrfDatBufTxWriteReq(id, dat)
% ==============================================================================
%  Copyright (C) BAY9, 2013
% ==============================================================================
%
% Syntax:
%   cfm = msgVrfDatBufTxWriteReq(id, dat)
%
% Inputs:
%   id          - Target identifier
%   dat         - Data to write
%
% Outputs:
%   cfm         - MsgIdVrf.DatBufTxWriteCfm
%
% Description:
%   Write to TX data buffer
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdVrf.DatBufTxWriteReq length(dat) dat];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);

  % Check confirm
  if (cfm(1) ~= MsgIdVrf.DatBufTxWriteCfm)
    error('Wrong confirm message received');
  end
  
% ==============================================================================
