function cfm = msgVrfDatBufTxStartReq(id, len)
% ==============================================================================
%  Copyright (C) BAY9, 2013
% ==============================================================================
%
% Syntax:
%   cfm = msgVrfDatBufTxStartReq(id, len)
%
% Inputs:
%   id          - Target identifier
%   len         - Number of data to write
%
% Outputs:
%   cfm         - MsgIdVrf.DatBufTxStartCfm
%
% Description:
%   Prepare TX data buffer to send data to PHY1-TX
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdVrf.DatBufTxStartReq len];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);

  % Check confirm
  if (cfm(1) ~= MsgIdVrf.DatBufTxStartCfm)
    error('Wrong confirm message received');
  end
  
% ==============================================================================
