function cfm = msgVrfDatBufTxFillReq(id, numDat, initDat, cntRnd, endZero)
% ==============================================================================
%  Copyright (C) BAY9, 2013
% ==============================================================================
%
% Syntax:
%   cfm = msgVrfDatBufTxFillReq(id, numDat, initDat, cntRnd, endZero)
%
% Inputs:
%   id          - Target identifier
%   numDat      - Number of data to write
%   initDat     - Initial word to write
%   cntRnd      - 0 = count up, 1 = random data
%   endZero     - 0 / 1 = Do not / do set the last 4 words to zero
%
% Outputs:
%   cfm         - MsgIdVrf.DatBufTxFillCfm
%
% Description:
%   Fill TX data buffer from the internal data generator. Data can either just
%   count up or use a simple LFSR for pseudo-random data generation. If random
%   data generation is chosen together with initDat = 0, the all data will be
%   zero due to the nature of LFSRs.
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdVrf.DatBufTxFillReq, numDat, initDat, cntRnd, endZero];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);

  % Check confirm
  if (cfm(1) ~= MsgIdVrf.DatBufTxFillCfm)
    error('Wrong confirm message received');
  end
  
% ==============================================================================
