function cfm = msgVrfDatBufRxStartReq(id, len)
% ==============================================================================
%  Copyright (C) BAY9, 2013
% ==============================================================================
%
% Syntax:
%   cfm = msgVrfDatBufRxStartReq(id, len)
%
% Inputs:
%   id          - Target identifier
%   len         - Number of data to read
%
% Outputs:
%   cfm         - MsgIdVrf.DatBufRxStartCfm
%
% Description:
%   Prepare RX data buffer to accept data from PHY1-RX
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdVrf.DatBufRxStartReq len];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);

  % Check confirm
  if (cfm(1) ~= MsgIdVrf.DatBufRxStartCfm)
    error('Wrong confirm message received');
  end
  
% ==============================================================================
