function [dat cfm] = msgVrfDatBufRxReadReq(id, len)
% ==============================================================================
%  Copyright (C) BAY9, 2013
% ==============================================================================
%
% Syntax:
%   [dat cfm] = msgVrfDatBufRxReadReq(id, len)
%
% Inputs:
%   id          - Target identifier
%   len         - Number of data to read
%
% Outputs:
%   dat         - Data read from interface
%   cfm         - MsgIdVrf.DatBufRxReadCfm
%
% Description:
%   Read from RX data buffer
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdVrf.DatBufRxReadReq len];
  nCfm  = len+1;
  cfm   = sendMsg(id, req, nCfm);

  % Check confirm
  if (cfm(1) ~= MsgIdVrf.DatBufRxReadCfm)
    error('Wrong confirm message received');
  end
  
  % Return results
  dat = cfm(2:end);
  cfm = cfm(1);

% ==============================================================================
