function [err cfm] = msgVrfDatBufRxCheckReq(id, numDat, initDat, cntRnd, endZero)
% ==============================================================================
%  Copyright (C) BAY9, 2013
% ==============================================================================
%
% Syntax:
%   cfm = msgVrfDatBufRxCheckReq(id, numDat, initDat, cntRnd, endZero)
%
% Inputs:
%   id          - Target identifier
%   numDat      - Number of data to write
%
% Outputs:
%   cfm         - MsgIdVrf.DatBufRxCheckCfm
%
% Description:
%   Compare RX data buffer with the internal data generator. Data can either just
%   count up or use a simple LFSR for pseudo-random data generation. If random
%   data generation is chosen together with initDat = 0, the all data will be
%   zero due to the nature of LFSRs.
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdVrf.DatBufRxCheckReq, numDat, initDat, cntRnd, endZero];
  nCfm  = 2;
  cfm   = sendMsg(id, req, nCfm);

  % Check confirm
  if (cfm(1) ~= MsgIdVrf.DatBufRxCheckCfm)
    error('Wrong confirm message received');
  end

  % Return error
  err = cfm(2);
  cfm = cfm(1);
  
% ==============================================================================
