function cfm = msgVrfExtIfWrReq(id, ctrlIfIdx, dat)
% ==============================================================================
%  Copyright (C) BAY9, 2013
% ==============================================================================
%
% Syntax:
%   cfm = msgVrfExtIfWrReq(id, ctrlIfIdx, dat)
%
% Inputs:
%   id          - Target identifier
%   ctrlIfIdx   - Index of external interface target
%   dat         - Data to write (row vector)
%
% Outputs:
%   cfm         - MsgIdVrf.ctrlWrCfm
%
% Description:
%   Write data to ctrlIfPhy[0|1]Out.
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdVrf.CtrlWrReq ctrlIfIdx length(dat) dat];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);

  % Check confirm
  if (cfm(1) ~= MsgIdVrf.CtrlWrCfm)
    error('Wrong confirm message received');
  end

% ==============================================================================
