function [dat cfm] = msgVrfExtIfRdReq(id, ctrlIfIdx, len)
% ==============================================================================
%  Copyright (C) BAY9, 2013
% ==============================================================================
%
% Syntax:
%   [dat cfm] = msgVrfExtIfRdReq(id, ctrlIfIdx, len)
%
% Inputs:
%   id          - Target identifier
%   ctrlIfIdx   - Index of external interface target
%   len         - Number of data to read
%
% Outputs:
%   dat         - Data read from interface
%   cfm         - MsgIdVrf.ctrlRdCfm
%
% Description:
%   Read data from ctrlIfPhy[0|1]In.
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdVrf.CtrlRdReq ctrlIfIdx len];
  nCfm  = len+1;
  cfm   = sendMsg(id, req, nCfm);

  % Check confirm
  if (cfm(1) ~= MsgIdVrf.CtrlRdCfm)
    error('Wrong confirm message received');
  end
  
  % Return results
  dat = cfm(2:end);
  cfm = cfm(1);

% ==============================================================================
