function cfm = msgVrfCfgTxPaReq(id, bypass)
% ==============================================================================
%  Copyright (C) BAY9, 2014
% ==============================================================================
%
% Syntax:
%   cfm = msgVrfCfgTxPaReq(id, bypass)
%
% Inputs:
%   id            - Target identifier
%   bypass        - 0/1 = do not / do bypass PA model
%
% Outputs:
%   cfm           - [MsgIdVrf.CfgTxPaCfm status]
%
%  Description:
%    The message switches the PA bypass on/off
% 
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdVrf.CfgTxPaReq bypass];
  nCfm  = 2;
  cfm   = sendMsg(id, req, nCfm);

  % Check confirm
  if (cfm(1) ~= MsgIdVrf.CfgTxPaCfm)
    error('Wrong confirm message received');
  end
  
  % Check if message is supported
  if (cfm(2) ~= 0)
    fprintf('Warning:\n  -> PA modeling not supported, msg has no effect\n');
  end
  
% ==============================================================================
