function cfm = msgVrfCfgTxInpScReq(id, inpBackOffDb)
% ==============================================================================
%  Copyright (C) BAY9, 2013
% ==============================================================================
%
% Syntax:
%   cfm = msgVrfCfgTxInpScReq(id, inpBackOffDb)
%
% Inputs:
%   id            - Target identifier
%   inpBackOffDb  - Input backoff in dB
%
% Outputs:
%   cfm           - MsgIdVrf.CfgTxInpScCfm
%
% Description:
%   Calculate the TX scaling factor as
%
%     txFactor = 4096 * 10^((inpBackOffDb-20)/20)
%
%   and check the range of the output value. Since txFactor is between
%   0..32767, and input backoff is always > 0, the message works for
%   input backoffs from about 0..38 dB. Effectively, this message yields
%   a default offset of 20 dB with respect to 16 bit full scale.
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Calculate TX scaling factor + check for error
  txFactor     = round(4096 * 10^((inpBackOffDb-20)/20));
  if (txFactor > 32767)
    error('Input back of input too large');
  end
  
  % Send message
  req   = [MsgIdVrf.CfgTxInpScReq txFactor];
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);

  % Check confirm
  if (cfm(1) ~= MsgIdVrf.CfgTxInpScCfm)
    error('Wrong confirm message received');
  end
  
% ==============================================================================
