function cfm = msgVrfCfgTxDcOffReq(id, dcOffRe, dcOffIm)
% ==============================================================================
%  Copyright (C) BAY9, 2013
% ==============================================================================
%
% Syntax:
%   cfm = msgVrfCfgTxDcOffReq(id, dcOffRe, dcOffIm)
%
% Inputs:
%   id            - Target identifier
%   dcOffRe       - DC offset, real part, -32767..+32767
%   dcOffIm       - DC offset, imag part, -32767..+32767
%
% Outputs:
%   cfm           - MsgIdVrf.CfgTxDcOffCfm
%
% Description:                                                         
%   The message add DC offset the TX path. The typical RMS of the      
%   complex valued data signal is 32768*10^(-bo/20), where where bo    
%   is the backOff in dB used throughout the system (20 dB). Hence, DC 
%   offset must be seen relative of to signal RMS = 3276.8.            
%
%   The function checks the confirm MsgId and the return status.       
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Check input range
  if (dcOffRe < -32767 || dcOffRe > 32767)
    error('TX DC offset real part outside allowed range [-32767..32767]');
  end
  if (dcOffIm < -32767 || dcOffIm > 32767)
    error('TX DC offset imag part outside allowed range [-32767..32767]');
  end
  
  % Send message
  req   = [MsgIdVrf.CfgTxDcOffReq dcOffRe dcOffIm];
  nCfm  = 2;
  cfm   = sendMsg(id, req, nCfm);

  % Check confirm
  if (cfm(1) ~= MsgIdVrf.CfgTxDcOffCfm)
    error('Wrong confirm message received');
  end
  
  % Check if message is supported
  if (cfm(2) ~= 0)
    fprintf('Warning:\n  -> TX DC offset not supported, msg has no effect\n');
  end
  
% ==============================================================================
