function cfm = msgVrfCfgRxDcOffReq(id, dcOffRe, dcOffIm)
% ==============================================================================
%  Copyright (C) BAY9, 2013
% ==============================================================================
%
% Syntax:
%   cfm = msgVrfCfgRxDcOffReq(id, dcOffRe, dcOffIm)
%
% Inputs:
%   id            - Target identifier
%   dcOffRe       - DC offset, real part, -32767..+32767
%   dcOffIm       - DC offset, imag part, -32767..+32767
%
% Outputs:
%   cfm           - [MsgIdVrf.CfgRxDcOffCfm status]
%
% Description:                                                              
%   The message add DC offset the RX path. The DC offset is shifted >> 4    
%   along with the signal before entering the RX core. The effect of DC     
%   offset must be seen relative to reception level which is dependent on   
%   gain setting.
%
%   The function checks the confirm MsgId and the return status.       
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Check input range
  if (dcOffRe < -32767 || dcOffRe > 32767)
    error('RX DC offset real part outside allowed range [-32767..32767]');
  end
  if (dcOffIm < -32767 || dcOffIm > 32767)
    error('RX DC offset imag part outside allowed range [-32767..32767]');
  end
  
  % Send message
  req   = [MsgIdVrf.CfgRxDcOffReq dcOffRe dcOffIm];
  nCfm  = 2;
  cfm   = sendMsg(id, req, nCfm);

  % Check confirm
  if (cfm(1) ~= MsgIdVrf.CfgRxDcOffCfm)
    error('Wrong confirm message received');
  end
  
  % Check if message is supported
  if (cfm(2) ~= 0)
    fprintf('Warning:\n  -> RX DC offset not supported, msg has no effect\n');
  end
  
% ==============================================================================
