function cfm = msgVrfCfgGpoReq(id, dat, mask)
%==============================================================================
%  Copyright (C) BAY9, 2013
%===============================================================================
%
% Syntax:
%   cfm = msgVrfCfgGpoReq(id, dat, mask)
%
% Inputs:
%   id          - Target identifier
%   dat         - Data bits
%   mask        - Mask bits
%
% Outputs:
%   cfm         - MsgIdVrf.CfgGpoCfm + updated data
%
% Description:
%   Send the GPO config request message
%
%     req = [MsgIdVrf.CfgGpoReq, dat, mask]
%
%   and read the updated value. If mask = 0, this will return
%   the current value of the GPOs.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Send message
  req   = [MsgIdVrf.CfgGpoReq, dat, mask];
  nCfm  = 2;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdVrf.CfgGpoCfm)
    fprintf('Error sending Gpo config request\n');
    pause
  end

%===============================================================================
