function cfm = msgVrfCfgDacRateReq(id, p, q)
% ==============================================================================
%  Copyright (C) BAY9, 2013
% ==============================================================================
%
% Syntax:
%   cfm = msgVrfCfgDacRateReq(id, p, q)
%
% Inputs:
%   id          - Target identifier
%   p           - DAC rate numerator, 1..2^32-1
%   q           - DAC rate denominator, p..2^32-1
%
% Outputs:
%   cfm         - MsgIdVrf.CfgDacRateCfm
%
% Description:
%   Send the GPO config request message
%
%     req = [MsgIdVrf.CfgDacRate, pLo16, pHi16, qLo16, qHi16]
%
%   and read the confirm message.
%
% ==============================================================================

  % ----------------------------------------------------------------------------
  % Global defintions
  global MsgIdVrf;

  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------
  % Check input range
  if (p < 1 || p >= 2^32 || q < 1 || q >= 2^32 )
    p, q
    error('DAC rate numerator (p) or denominator (q) out of range');
  end

  if (p > q)
    p, q
    error('DAC rate numerator (p) must be smaller or equal denominator (q)');
  end
  
  % Send message
  pLo16   = mod(p, 2^16);
  pHi16   = floor(p/2^16);
  qLo16   = mod(q, 2^16);
  qHi16   = floor(q/2^16);
  req   = [MsgIdVrf.CfgDacRateReq, pLo16, pHi16, qLo16, qHi16];
  nCfm  = 2;
  cfm   = sendMsg(id, req, nCfm);
  
  % Debug: check confirm
  if (cfm(1) ~= MsgIdVrf.CfgDacRateCfm)
    fprintf('Error sending DAC rate config request\n');
    pause
  end

  % Check if message is supported
  if (cfm(2) ~= 0)
    fprintf('Warning, DAC rate setting not supported, message has no effect\n');
  end

% ==============================================================================
