function cfm = msgVrfBootReq(id)
%===============================================================================
%  Copyright (C) BAY9, 2011
%===============================================================================
%
% Syntax:
%   cfm = msgVrfBootReq(id)
%
% Inputs:
%   id          - Target identifier
%
% Outputs:
%   --
%
% Description:
%   Boot the VRF system via UART or external interface.
%   After booting, evaluate the confirm and possibly get the version
%   number.
%
%   Note, this is not really a message although it makes use of the 
%   control interface.
%
%===============================================================================

  % ----------------------------------------------------------------------------
  % Global definitions
  global MsgIdVrf;
  
  % Define message core
  id.core = 'vrf';
  
  % ----------------------------------------------------------------------------  
  % Get current boot data file
  fileName  = which(mfilename);
  q         = findstr(fileName, '/');
  q         = q(end-1);
  datDir    = fileName(1:q-1);
  bootFile  = [datDir '/dat/boot.bin'];

  % Read the boot data file
  fid     = fopen(bootFile, 'r');
  bootDat = fread(fid, Inf, 'uint16')';
  fclose(fid);
  
  % Send boot data
  req   = bootDat;
  nCfm  = 1;
  cfm   = sendMsg(id, req, nCfm);

  % ----------------------------------------------------------------------------  
  % Debug only, check confirm
  %  -> send version request, print the version  
  if (cfm == MsgIdVrf.BootCfm)
    fprintf('Booting VRF OK\n');
  else
    fprintf('Boot error, cfm = %d\n', cfm);
    pause
  end
    
%===============================================================================
